local assets=
{ 
    Asset("ANIM", "anim/wand_spas.zip"),
	Asset("ANIM", "anim/swap_wand_spas.zip"),
    Asset("ATLAS", "images/inventoryimages/wand_spas.xml"),
	Asset("IMAGE", "images/inventoryimages/wand_spas.tex"),
}

local dam = 97

local function onattack_spas(inst, owner, target)
    inst.SoundEmitter:PlaySound("shots/gunshot/shot1270")	
	owner.components.inventory:ConsumeByName("shot1270", 1)	
end

local function OnEquip(inst, owner) 
        owner.AnimState:OverrideSymbol("swap_object", "swap_wand_spas", "wand")
        owner.AnimState:Show("ARM_carry") 
        owner.AnimState:Hide("ARM_normal") 
end

local function OnUnequip(inst, owner) 
        owner.AnimState:Hide("ARM_carry") 
        owner.AnimState:Show("ARM_normal") 
end



local function fn(colour)

	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter() 
    ---- 
    MakeInventoryPhysics(inst)
    
	
    anim:SetBank("wand")
    anim:SetBuild("wand_spas")
    anim:PlayAnimation("idle")
	
	
	inst:AddComponent("weapon")
	inst.components.weapon:SetDamage(dam)
    inst.components.weapon:SetRange(8)
    inst.components.weapon:SetOnAttack(onattack_spas)
    inst.components.weapon:SetProjectile("shot1270")
		
	inst:AddComponent("inspectable")
		
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "wand_spas"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/wand_spas.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
	
	inst.HasAmmo = function(inst, owner)
		if (owner and owner.components.inventory and owner.components.inventory:Has("shot1270", 1)) or (owner:HasTag("ai")) then
			return true
		end
		return false
	end
	
    return inst
end

return  Prefab("common/inventory/wand_spas", fn, assets)